<?php
// Cria a pasta qrcode se não existir
if (!file_exists('qrcode')) {
    mkdir('qrcode', 0755, true);
}

// Salvar dados no arquivo JSON
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se um arquivo foi enviado
    $qrcodePath = $_POST['qrcode'] ?? '';
    if (isset($_FILES['qrcode_arquivo']) && $_FILES['qrcode_arquivo']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['qrcode_arquivo']['name'], PATHINFO_EXTENSION);
        $nomeArquivo = uniqid('qr_') . '.' . $ext;
        $destino = 'qrcode/' . $nomeArquivo;
        move_uploaded_file($_FILES['qrcode_arquivo']['tmp_name'], $destino);
        $qrcodePath = $destino;
    }

    // Formata valor como float (retira vírgula e converte para ponto)
    $valorRaw = $_POST['valor'] ?? '0';
    $valorFloat = str_replace(',', '.', preg_replace('/[^\d,]/', '', $valorRaw));

    $dados = [
        'qrcode'       => $qrcodePath,
        'nome'         => $_POST['nome'] ?? '',
        'controle'     => $_POST['controle'] ?? '',
        'valor'        => number_format((float)$valorFloat, 2, ',', '.'), // Valor formatado como R$ brasileiro
        'data'         => date('Y-m-d'),
        'banco'        => $_POST['banco'] ?? ''
    ];
    file_put_contents('comprovante_config.json', json_encode($dados, JSON_PRETTY_PRINT));
    $mensagem = "Dados salvos com sucesso!";
}

// Carregar dados já existentes
$config = file_exists('comprovante_config.json') ? json_decode(file_get_contents('comprovante_config.json'), true) : [];

$qr            = $config['qrcode'] ?? '';
$nome          = $config['nome'] ?? '';
$controle      = $config['controle'] ?? '';
$valor         = $config['valor'] ?? '';
$data          = $config['data'] ?? date('Y-m-d');
$banco         = $config['banco'] ?? '';
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Configuração do Comprovante</title>
  <link rel="shortcut icon" href="favicon.ico" />
</head>
<body style="font-family: Arial, sans-serif; max-width: 600px; margin: 40px auto;">

  <h2 style="text-align:center; color:#444;">Configurar Comprovante</h2>

  <?php if (!empty($mensagem)): ?>
    <div style="color: green; text-align: center; margin-bottom: 15px;">
      <?= htmlspecialchars($mensagem) ?>
    </div>
  <?php endif; ?>

  <form method="post" enctype="multipart/form-data">
    <label>URL do QR Code:</label>
    <input type="text" name="qrcode" placeholder="https://..." style="width:100%; padding:8px; margin-bottom:10px;" value="<?= htmlspecialchars($qr) ?>">

    <label>Ou selecione o QR Code do seu computador:</label>
    <input type="file" name="qrcode_arquivo" accept="image/*" style="width:100%; padding:8px; margin-bottom:10px;">

    <label>Nome do Cliente:</label>
    <input type="text" name="nome" style="width:100%; padding:8px; margin-bottom:10px;" value="<?= htmlspecialchars($nome) ?>">

    <label>Número de Controle:</label>
    <input type="text" name="controle" style="width:100%; padding:8px; margin-bottom:10px;" value="<?= htmlspecialchars($controle) ?>">

    <label>Valor:</label>
    <input type="text" name="valor" placeholder="Ex: 199,90" style="width:100%; padding:8px; margin-bottom:10px;" value="<?= htmlspecialchars($valor) ?>">

    <label>Banco:</label>
    <input type="text" name="banco" style="width:100%; padding:8px; margin-bottom:10px;" value="<?= htmlspecialchars($banco) ?>">

    <button type="submit" style="padding: 10px 20px; background-color: #7a6600; color: white; border: none; cursor: pointer;">Salvar</button>
  </form>

</body>
</html>
